#include <iostream>
#include <string>

#include "eval.h"
#include "defs.h"
#include "pawntab.h"
#include "squares.h"
#include "bits.h"

void cEval::score_rooks(cBoard &brd, cMaterial &mat)
{
    uint pcenum;
	uint piece;
	uint *board = brd.p2board();
	uint sq;
	uint enemy = cB;
	uint rank;
	uint file;
	uint oppkingrank;
	u64 wocc;
    u64 bocc;

    wocc = mat.getboard(pwP);
    bocc = mat.getboard(pbP);

	piece = pwR;
	pcenum = mat.getpcenum(piece);
    ASS(pcenum<maxpiecenum);

    oppkingrank = ranks[mat.getkingsq(cB)];

    ASS(oppkingrank>=RANK1&&oppkingrank<=RANK8);

    while(pcenum)
    {
      sq = mat.getpcesq(piece, pcenum);

      ASS(onbrd(sq));
      ASS(board[sq]==piece);

      file = files[sq];
      rank = ranks[sq];

      ASS(file>=FILEA&&file<=FILEH);
      ASS(rank>=RANK1&&rank<=RANK8);

      if(FILEOPEN(wocc, file))
      {
          pos[cW][OPE] += rooksemiopenfile;
          pos[cW][END] += rooksemiopenfile;

          if(FILEOPEN(bocc, file))
          {
              pos[cW][OPE] += rookopenfile;
              pos[cW][END] += rookopenfile;
          }
      }

      if(rank==RANK7 && ( RANKOCC(bocc, rank) || oppkingrank >= RANK7) )
      {
          pos[cW][OPE] += rookseventhrank;
          pos[cW][END] += rookseventhrank;
      }
      pcenum--;
    }


    piece = pbR;
	pcenum = mat.getpcenum(piece);
    ASS(pcenum<maxpiecenum);

    oppkingrank = ranks[mat.getkingsq(cW)];

    ASS(oppkingrank>=RANK1&&oppkingrank<=RANK8);

    while(pcenum)
    {
      sq = mat.getpcesq(piece, pcenum);

      ASS(onbrd(sq));
      ASS(board[sq]==piece);

      file = files[sq];
      rank = ranks[sq];

      ASS(file>=FILEA&&file<=FILEH);
      ASS(rank>=RANK1&&rank<=RANK8);

      if(FILEOPEN(bocc, file))
      {
          pos[cB][OPE] += rooksemiopenfile;
          pos[cB][END] += rooksemiopenfile;

          if(FILEOPEN(wocc, file))
          {
              pos[cB][OPE] += rookopenfile;
              pos[cB][END] += rookopenfile;
          }
      }

      if(rank==RANK2 && ( RANKOCC(wocc, rank) || oppkingrank <= RANK2) )
      {
          pos[cB][OPE] += rookseventhrank;
          pos[cB][END] += rookseventhrank;
      }
      pcenum--;
    }
}